#!/usr/bin/env bash
#  Copyright (c) 2023-2023, Ciena Corporation
#  All rights reserved.

function openssl_error_check {
    # Your cleanup code here
    if [ ! "$?" == "0" ]; then
        echo "ERROR=Unable to load ConfD Encrypted Strings; OpenSSL key generation failed."
    fi
}

# Check that the 'cat' utility exists
CAT=$(which cat)
if [ -z "${CAT}" ]; then
    echo "ERROR=Unable to load ConfD Encrypted Strings; missing 'cat' utility."
    exit 1
fi

# Check that the 'openssl' utility exists
OPENSSL=$(which openssl)
if [ -z "${OPENSSL}" ]; then
    echo "ERROR=Unable to load ConfD Encrypted Strings; missing 'openssl' utility."
    exit 1
fi

# If the confd_keys.conf file does not exist, generate it now with RW permissions
# for the user only.
CONFD_KEYS_FILE=/etc/tibit/netconf/confd/confd_keys.conf
if [ ! -f "${CONFD_KEYS_FILE}" ]; then

trap openssl_error_check EXIT
set -euET -o pipefail
DES3CBC_KEY1=$(${OPENSSL} rand -hex 8 2> /dev/null)
DES3CBC_KEY2=$(${OPENSSL} rand -hex 8 2> /dev/null)
DES3CBC_KEY3=$(${OPENSSL} rand -hex 8 2> /dev/null)
DES3CBC_IV=$(${OPENSSL} rand -hex 8 2> /dev/null)
AESCFB128_KEY=$(${OPENSSL} rand -hex 16 2> /dev/null)
AESCFB128_IV=$(${OPENSSL} rand -hex 16 2> /dev/null)
AES256CFB128_KEY=$(${OPENSSL} rand -hex 32 2> /dev/null)

UMASK_ORIG=`umask`
umask 077
cat << EOF > ${CONFD_KEYS_FILE}
DES3CBC_KEY1=${DES3CBC_KEY1}
DES3CBC_KEY2=${DES3CBC_KEY2}
DES3CBC_KEY3=${DES3CBC_KEY3}
DES3CBC_IV=${DES3CBC_IV}
AESCFB128_KEY=${AESCFB128_KEY}
AESCFB128_IV=${AESCFB128_IV}
AES256CFB128_KEY=${AES256CFB128_KEY}
EOF
umask ${UMASK_ORIG}

fi

# Print the keys to stdout
exec ${CAT} ${CONFD_KEYS_FILE}