#--------------------------------------------------------------------------#
# Copyright (c) 2025, Ciena Corporation                                    #
# All rights reserved.                                                     #
#                                                                          #
#     _______ _____ __    __ ___                                           #
#    / _ __(_) ___//  |  / // _ |                                          #
#   / /   / / /__ / /|| / // / ||                                          #
#  / /___/ / /__ / / ||/ // /__||                                          #
# /_____/_/_____/_/  |__//_/   ||                                          #
#                                                                          #
# Distributed as Ciena-Customer confidential.                              #
#                                                                          #
#--------------------------------------------------------------------------#

import os
import json
import shutil

from pymongo import MongoClient

# This script will return all the needed seed files for the 'documents' folder.
# Before using, create clean db and run the PC and PON Auto on it as well as the json to mongo scripts for each.
# Run with the following command:
# python3 get_seed_documents.py
# The results will show up in databaseSeedFiles/scriptResultDocuments/ unless you change the 'parent_folder' variable.

# Connect to MongoDB
client = MongoClient('mongodb://10.1.20.102:27017')
db = client['40_clean_db']

# List of collections
collections = [
    'CNTL-ALARM-CFG',
    'OLT-ALARM-CFG',
    'ONU-ALARM-CFG',
    'CNTL-CFG',
    'OLT-CFG',
    'ONU-CFG',
    'SWI-CFG',
    'DS-MAP-CFG',
    'AUTO-CFG',
    'CNTL-AUTO-CFG',
    'OLT-AUTO-CFG',
    'ONU-AUTO-CFG',
    'SWI-AUTO-CFG',
    'SLA-CFG',
    'SRV-CFG',
]

# Directories where the documents will be placed when returned.
# NOTE they are in the same order as the "collections" array
folder_names = [
    'alarmConfigs/controllers',
    'alarmConfigs/olts',
    'alarmConfigs/onus',
    'deviceConfigs/controllers',
    'deviceConfigs/olts',
    'deviceConfigs/onus',
    'deviceConfigs/switches',
    'dsMapConfigs',
    'ponAutoConfigs/automation',
    'ponAutoConfigs/controllers',
    'ponAutoConfigs/olts',
    'ponAutoConfigs/onus',
    'ponAutoConfigs/switches',
    'slaConfigs',
    'srvConfigs',
]

# Folder path to save JSON documents
parent_folder = 'databaseSeedFiles/documents/'

# Delete sub-folders if they already exist
if os.path.exists(parent_folder):
    shutil.rmtree(parent_folder)

# Loop through all collections
for i, collection_name in enumerate(collections):
    collection = db[collection_name]
    folder_name = folder_names[i] if i < len(folder_names) else 'default_folder'
    folder_path = os.path.join(parent_folder, folder_name)

    # Create the sub-folders
    os.makedirs(folder_path, exist_ok=True)

    # Find the default document
    if collection_name == 'SRV-CFG':
        documents = collection.find()
    else:
        documents = collection.find({'_id': {'$in': ['Default', 'Global', 'Max', 'Min']}})

    for document in documents:
        if collection_name == 'SRV-CFG':
            file_name = f"SRV-{document['_id']}-CFG.json"
        else:
            file_name = f"{collection_name}-{document['_id']}.json"

        file_path = os.path.join(folder_path, file_name)

        # Write the data to the file
        with open(file_path, 'w') as json_file:
            json.dump(document, json_file, indent=4)

print('*** Done ***')
