#!/usr/bin/env bash
#--------------------------------------------------------------------------#
# Copyright (C) 2015 - 2022 by Tibit Communications, Inc.                  #
# All rights reserved.                                                     #
#                                                                          #
#    _______ ____  _ ______                                                #
#   /_  __(_) __ )(_)_  __/                                                #
#    / / / / __  / / / /                                                   #
#   / / / / /_/ / / / /                                                    #
#  /_/ /_/_____/_/ /_/                                                     #
#                                                                          #
#                                                                          #
#--------------------------------------------------------------------------#

VERSION=R5.2.0
LogFile=uninstall.log

exec > >( tee -a "${LogFile}" )
exec 2> >( tee -a "${LogFile}" >&2 )

if [[ $(id -u) -ne 0 ]] ; then 
    echo "Please run as root"
    exit 1
fi

echo "Stopping apache2 service....."
service apache2 stop

echo "Removing tibit-ponmgr....."
sudo apt-get remove tibit-ponmgr --purge -y
sudo rm -rf /etc/tibit/ponmgr
sudo rm -rf /opt/tibit/ponmgr

echo "Removing apache2....."
sudo apt-get remove apache2 --purge -y

echo "Stopping tibit-poncntl service....."
sudo service tibit-poncntl stop

echo "Removing tibit-poncntl...."
sudo apt-get purge tibit-poncntl -y
sudo rm -rf /opt/tibit/poncntl

##VENKO Customization: Remove venko-vlan_setup.service
echo "Stopping venko-vlan_setup.service...."
sudo service venko-vlan_setup stop
sudo systemctl disable venko-vlan_setup

echo"Removing venko-vlan-setup.service...."
sudo rm /etc/systemd/system/venko-vlan_setup.service
##END VENKO Customization: Remove venko-vlan_setup.service

echo "Stopping tibit-netconf service....."
sudo service tibit-netconf stop

echo "Removing tibit-netconf....."
sudo apt-get purge tibit-netconf -y

echo "Removing tibit-snmp....."
sudo apt-get purge tibit-snmp -y

echo "Stopping mongodb service....."
sudo service mongod stop
sudo rm -rf /var/lib/mongodb
sudo rm -rf /tmp/mongodb-*.sock

echo "Removing Tibit directories....."
sudo rm -rf /opt/tibit
sudo rm -rf /etc/tibit
sudo rm -rf /var/log/tibit
sudo rm -rf /etc/apache2/sites-available/tibit*
