#!/usr/bin/env bash
#--------------------------------------------------------------------------#
#  Copyright (c) 2022-2024, Ciena Corporation                              #
#  All rights reserved.                                                    #
#                                                                          #
#     _______ _____ __    __ ___                                           #
#    / _ __(_) ___//  |  / // _ |                                          #
#   / /   / / /__ / /|| / // / ||                                          #
#  / /___/ / /__ / / ||/ // /__||                                          #
# /_____/_/_____/_/  |__//_/   ||                                          #
#                                                                          #
#  PROPRIETARY NOTICE                                                      #
#  This Software consists of confidential information.                     #
#  Trade secret law and copyright law protect this Software.               #
#  The above notice of copyright on this Software does not indicate        #
#  any actual or intended publication of such Software.                    #
#                                                                          #
#--------------------------------------------------------------------------#

usage () {
    cat <<HELP_USAGE

    $0  <username> <group>

    Configure the NACM by adding username to the specified group.

HELP_USAGE

exit 0
}

# Check root access
if [[ $EUID > 0 ]]; then
  echo "Root level access is required. Please use 'sudo' to run the $0 script."
  exit
fi

[ -z $1 ] && { usage; }
[ -z $2 ] && { usage; }

NACM_USER=$1
NACM_GROUP=$2

# First check if the NACM group exists
echo "Verifying NACM group '${NACM_GROUP}' exists."
source /opt/tibit/confd/confdrc
$(${CONFD_DIR}/bin/confd_load -p /nacm/groups/group{${NACM_GROUP}} -F P | grep "<name>" &> /dev/null)
if [ "$?" = "0" ]; then
    echo "Success."
else
    echo "Failed - please configure NACM group '${NACM_GROUP}' before adding users."
    exit 1
fi


# Apply configuration to the running datastore.
echo "Configuring NACM - adding user '${NACM_USER}' to group '${NACM_GROUP}'..."
source /opt/tibit/confd/confdrc
${CONFD_DIR}/bin/confd_load -l -m - << EDITCONFIGXML
<config xmlns="http://tail-f.com/ns/config/1.0">
  <nacm xmlns="urn:ietf:params:xml:ns:yang:ietf-netconf-acm">
    <groups>
      <group>
        <name>${NACM_GROUP}</name>
        <user-name nc:operation="merge" xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">${NACM_USER}</user-name>
      </group>
    </groups>
  </nacm>
</config>
EDITCONFIGXML

if [ "$?" = "0" ]; then
    echo "Success."
else
    echo "Failed."
    exit 1
fi

exit 0
