#!/usr/bin/env bash

echo "Checking system compatibility....."
build_os="$(lsb_release -i -s)$(lsb_release -r -s)"
if [ "${build_os}" == "Ubuntu18.04" ] || [ "${build_os}" == "Ubuntu20.04" ]; then
  echo "Compatibility check succeeded....."
else
  echo "Ubuntu version \"${build_os}\" is not supported....."
  echo "Terminating installation of MongoDB....."
  exit 1
fi

echo "Stopping mongodb service....."
service mongod stop || true

echo "Removing mongodb....."
apt-get purge mongodb-org* || true

echo "Removing mongodb logs....."
rm -r /var/log/mongodb || true

echo "Removing mongodb configurations....."
rm -r /var/lib/mongodb || true
rm -r /data || true

echo "Adding MongoDB public GPG Key and creating list file for MongoDB....."
if [ "${build_os}" == "Ubuntu18.04" ] ; then
  wget -qO - https://www.mongodb.org/static/pgp/server-4.0.asc | apt-key add -
  echo "deb [ arch=amd64,arm64 ] https://repo.mongodb.org/apt/ubuntu bionic/mongodb-org/4.0 multiverse" | tee /etc/apt/sources.list.d/mongodb-org-4.0.list
elif [ "${build_os}" == "Ubuntu20.04" ] ; then
  wget -qO - https://www.mongodb.org/static/pgp/server-4.4.asc | apt-key add -
  echo "deb [ arch=amd64,arm64 ] https://repo.mongodb.org/apt/ubuntu focal/mongodb-org/4.4 multiverse" | tee /etc/apt/sources.list.d/mongodb-org-4.4.list
fi

echo "Updating....."
apt-get update

echo "Installing MongoDB and packages....."
apt-get install -y mongodb-org

echo "creating db directories....."
mkdir /data
mkdir /data/db

echo "Starting MongoDB....."
systemctl enable mongod.service
systemctl start mongod.service
