#!/usr/bin/env bash
# --------------------------------------------------------------------------#
#  Copyright (C) 2022 by Tibit Communications, Inc.                         #
#  All rights reserved.                                                     #
#                                                                           #
#     _______ ____  _ ______                                                #
#    /_  __(_) __ )(_)_  __/                                                #
#     / / / / __  / / / /                                                   #
#    / / / / /_/ / / / /                                                    #
#   /_/ /_/_____/_/ /_/                                                     #
#                                                                           #
#                                                                           #
#  Distributed as Tibit-Customer confidential                               #
#                                                                           #
# --------------------------------------------------------------------------#

TMPFILE=$(mktemp /tmp/tibit_nc_rpc.XXXXXX)

# Usage
usage () {
    cat <<HELP_USAGE

    $0

    Get all configuration and operational data and print XMl to stdout.

    Options:
      -h|--help       Display this help and usage text.
      -p|--port       TCP port number used to connect to the NETCONF Server (default: 830).
      -s|--server     Hostname or IP address used to connect to the NETCONF Server (default: localhost).
      -u|--username   Username with access to the NETCONF Server (default: $USER).

    Example:
      $0

HELP_USAGE

exit 0
}

# Defaults
HOST=localhost
PORT=830

# Parse command line arguments
PARAMS=""
while (( "$#" )); do
    case "$1" in
        -s|--server)
            HOST=$2
            shift 2
            ;;
        -p|--port)
            PORT=$2
            shift 2
            ;;
        -u|--username)
            USER=$2
            shift 2
            ;;
        -h|--help)
            usage
            ;;
        --) # end argument parsing
            shift
            break
            ;;
        -*|--*=) # unsupported option
            echo "Error: Unsupported option $1" >&2
            usage
            ;;
        *) # preserve positional arguments
            PARAMS="$PARAMS $1"
            shift
            ;;
    esac
done
# set positional arguments in their proper place
eval set -- "$PARAMS"

cat >${TMPFILE}  << EDITCONFIGXML
<get xmlns="urn:ietf:params:xml:ns:netconf:base:1.0">
</get>
EDITCONFIGXML

PATH=${PATH}:/opt/tibit/netconf/bin netopeer2-cli <<COMMANDINPUT
connect --host ${HOST} --port ${PORT} --login ${USER}
user-rpc --content ${TMPFILE}
exit
COMMANDINPUT

rm -rf ${TMPFILE}
