#
# How to Use Docker
#

This folder contains the modified files for generate a Tibit Package for Venko Networks using Docker Containers.
**Important**: Important this system does not use replicaset nor authentication for mongodb. Soon these features will be applied.

# Usage

First of all, you need install and configure docker to run correctly in your computer/vm. Do not forget the user permissions. Normally docker commands are executed without "sudo" user.

## Creating a Interface for Pon Controller.
- You can use the original script setup_vlan.sh to create a interface for PonController at host computer or you can create a vlan like enp4s0f1.4090  directly to 
netplan.

<pre><code>
network:
  version: 2
  renderer: NetworkManager
  ethernets:
    enp4s0f1:
      dhcp4: no
  vlans:
    enp4s0f1.4090:
      id: 4090
      link: enp4s0f1
</code></pre>

- This is the interface will be used at PonController Container as eth1. **Attention**: Please check correctly the correct interface of your host

## PonController Configuration
-  Edit PonCntlInit.json at R3.X.X-PonController/docker/.
-  Change the IP for mongo from 127.0.0.1 to db. 
-  At the end of the file change the interface to "interface": "eth1". (The interface with vlan from host will be eth1 inside of the Docker Container.)

## PonManager Configuration
- Edit the databases.json and user_database.json files for PonManager at R3.X.X-PonManager/docker/.]
- Change the IP for mongo from 127.0.0.1 to db  (this is the link for mongo inside of docker-compose.yml)
- Add line, in user_database file with django_key, like above:

<pre><code>
\"replica_set_hosts\": [],
\"django_key\": \"<generate django_key with script "generate_django_key.py" inside directory tools on R3.X.X-PonManager copy and paste here>\" 
</code></pre>

obs.: the comma after bracket in replica_set_hosts are important.

## Docker-Compose Configuration
For docker-compose use the file docker-compose.ym at folder Tibit-Venko-Files
### For Mongo

Change to the correct folder for your volume creation. The docker-compose will create a volume for MongoDB, change the folder at this point of docker-compose.yml
<code><pre>
Volumes: 
      - **/home/XXXXX/data/db**:/data/db 
</code></pre>      
### For PonController Interface
Add the corect interface for PonController. At the same docker-compose.yml change the interface and vlan at the end of file.
<code><pre>
  tibit4090:
    name: tibit4090
    driver: macvlan
    driver_opts:
      parent: **enp4s0f1.4090**
</code></pre>   

# Build images
- To build images you need change the versions of Tibit Tools and PonAuto (Today PonAutomatin has a different version than PonManager and PonController), for it edit the .env file at folder Tibit-Venko-Files
- Run command at folder Tibit-Venko-Files: **docker-compose build --no-cache**
- After that the images for MongoDb, Tibit PonManager and Tibit PonController will be created. (For default configuration PonAuto is not created)

# Run System
- To run execute docker-compose up -d at folder Tibit-Veko-Files, 
- 4 containers will be created, but one container for mongo will be used only for replicaset start. 
- If you want to see the logs during the containers creation remove the option -d from command line.

PonController and PonManager can be restarted using the http://LOCALIP:9001 and http://LOCALIP:9002 via a Supervisord page.




 
