#!/bin/bash
#
# Sysrepo shm_clean.sh script to clear out all /dev/shm resources related to Sysrepo
#

# Check root access
if [[ $EUID > 0 ]]; then
  echo "Root level access is required for uninstall. Please use 'sudo ./shm_clean.sh'."
  exit
fi

# Check the tibit-netconf server is not running
systemctl is-active --quiet tibit-netconf
if [ $? -eq 0 ]; then
  echo "The tibit-netconf service is running."
  echo "Please use 'sudo systemctl stop tibit-netconf' to stop the service before cleaning /dev/shm."
  exit
fi

# Clean up old /dev/shm
clean="/dev/shm/sr_*"
echo "Cleaning ${clean}."
rm -rf ${clean}
clean="/dev/shm/srsub_*"
echo "Cleaning ${clean}."
rm -rf ${clean}