#!/usr/bin/env python3
# --------------------------------------------------------------------------#
# Copyright (C) 2022 by Tibit Communications, Inc.                         #
# All rights reserved.                                                     #
#                                                                          #
#    _______ ____  _ ______                                                #
#   /_  __(_) __ )(_)_  __/                                                #
#    / / / / __  / / / /                                                   #
#   / / / / /_/ / / / /                                                    #
#  /_/ /_/_____/_/ /_/                                                     #
#                                                                          #
# --------------------------------------------------------------------------#

# Usage: python3 generate_django_key.py

import random
import string


def generate_key(printKey=False):
    try:
        allowed_characters = string.ascii_lowercase + string.digits + '!#$%&()*+,-.:;<=>?@[]^_{}~'
        secret_key_meets_requirements = False
        while not secret_key_meets_requirements:
            secret_key = ''.join(random.SystemRandom().choice(allowed_characters) for _ in range(50))
            unique_characters = len(set(secret_key))
            if unique_characters > 10:
                if printKey:
                    print(secret_key)
                    secret_key_meets_requirements = True
                else:
                    return secret_key

    except Exception as err:
        print("WARNING: Unable to generate Django SECRET_KEY")
        print(f"Exception: {err}")
        if printKey == False:
        	return ""

if __name__ == "__main__":
	generate_key(printKey=True)
	
