"""
#--------------------------------------------------------------------------#
# Copyright (C) 2022 by Tibit Communications, Inc.                         #
# All rights reserved.                                                     #
#                                                                          #
#    _______ ____  _ ______                                                #
#   /_  __(_) __ )(_)_  __/                                                #
#    / / / / __  / / / /                                                   #
#   / / / / /_/ / / / /                                                    #
#  /_/ /_/_____/_/ /_/                                                     #
#                                                                          #
# Distributed as Tibit-Customer confidential.                              #
#                                                                          #
#--------------------------------------------------------------------------#
"""

public_endpoint_prefixes = [
    "controllers",
    "switches/configs",
    "switches/automation",
    "olts",
    "onus",
    "cpes",
    "files",
    "slas",
    "service-configs",
    "databases",
    "users",
    "downstream-maps"
]


# =======================================
# ========= Preprocessing Hooks =========
# =======================================

def exclude_private_endpoints(endpoints):
    """ Filters private endpoints from generated list so they do not appear in the documentation """

    def filter_endpoints(endpoint):
        (path, _, _, _) = endpoint

        for prefix in public_endpoint_prefixes:
            if prefix in path:
                return True

        return False

    return filter(filter_endpoints, endpoints)
