"""
#--------------------------------------------------------------------------#
# Copyright (C) 2022 by Tibit Communications, Inc.                         #
# All rights reserved.                                                     #
#                                                                          #
#    _______ ____  _ ______                                                #
#   /_  __(_) __ )(_)_  __/                                                #
#    / / / / __  / / / /                                                   #
#   / / / / /_/ / / / /                                                    #
#  /_/ /_/_____/_/ /_/                                                     #
#                                                                          #
# Distributed as Tibit-Customer confidential.                              #
#                                                                          #
#--------------------------------------------------------------------------#
"""

from django.urls import path

from . import views

urlpatterns = [
    path('', views.Manage.as_view(), name='manage_databases'),
    path('selection/', views.Select.as_view(), name='select_database'),
    path('session/', views.SessionOnly.as_view(), name='select_database_for_session'),
    path('status/', views.ConnectionStatus.as_view(), name='check_database_statuses'),
    path('status/<str:database_id>/', views.OneConnectionStatus.as_view(), name='check_database_status'),
    path('<str:database_id>/', views.ManageOne.as_view(), name='manage_databases'),
]
