"""
#--------------------------------------------------------------------------#
# Copyright (C) 2022 by Tibit Communications, Inc.                         #
# All rights reserved.                                                     #
#                                                                          #
#    _______ ____  _ ______                                                #
#   /_  __(_) __ )(_)_  __/                                                #
#    / / / / __  / / / /                                                   #
#   / / / / /_/ / / / /                                                    #
#  /_/ /_/_____/_/ /_/                                                     #
#                                                                          #
# Distributed as Tibit-Customer confidential.                              #
#                                                                          #
#--------------------------------------------------------------------------#

api URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/1.9/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  url(r'^$', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  url(r'^$', Home.as_view(), name='home')
Including another URLconf
    1. Add an import:  from blog import urls as blog_urls
    2. Import the include() function: from django.conf.urls import url, include
    3. Add a URL to urlpatterns:  url(r'^blog/', include(blog_urls))

    ======================================================

    Url endpoints for Django API
"""

from django.conf.urls import url
from django.urls import path, include
from rest_framework.urlpatterns import format_suffix_patterns
from DBdjango import views

urlpatterns = [
    # API documentation endpoints
    path('<version>/docs/', include('docs.urls')),

    # PON Auto Endpoints
    path('<version>/pon_automation/', include('pon_automation.urls')),

    url(r'^pon_auto/tree/', views.GetPonAutoServicesForTree().as_view()),
    url(r'^pon_auto/state_count/', views.GetPonAutoStateCount().as_view()),
    url(r'^pon_auto/status/', views.GetPonAutoStatus().as_view()),

    # MGMT LAN Endpoint
    url(r'^mgmt_lan/tree/', views.GetMgmtLansForTree().as_view()),

    # Controller Endpoints
    path('<version>/controllers/', include('controllers.urls')),

    url(r'^controller/labels/', views.GetAllControllerLabels().as_view()),
    url(r'^controller/counts/', views.ControllerCounts().as_view()),
    url(r'^controller/unattached/', views.GetAllUnattachedControllers().as_view()),
    url(r'^controller/versions/', views.GetAllControllersWithVersions().as_view()),
    url(r'^controller/all/states/', views.GetAllCntlStates().as_view()),
    url(r'^controller/summary/(?P<mac_address>.+)/', views.GetControllerSummary().as_view()),
    url(r'^controller/tree/(?P<mgmt_lan>.+)/', views.GetAllCntlsForTree().as_view()),
    url(r'^controller/configurations/ids/', views.GetAllCntlCfgIds().as_view()),
    url(r'^controller/all/configurations/', views.GetAllCntlCfgs().as_view()),
    url(r'^controller/alarm/configuration/identifiers/', views.GetAllCntlAlarmsIds().as_view()),
    url(r'^controller/alarm/', views.GetAllCntlAlarms().as_view()),
    url(r'^controller/onu/upgrade/status/(?P<id>.+)/', views.ControllerOnuFirmwareUpgradeStatus().as_view()),
    url(r'^controller/auto/counts/', views.ControllerAutoCounts().as_view()),
    url(r'^controller/delete/(?P<mac_address>.+)/', views.DeleteController().as_view()),
    url(r'^controller/', views.GetCntls().as_view()),

    # Switch Endpoints
    path('<version>/switches/', include('switches.urls')),

    url(r'^switch/labels/', views.GetAllSwitchLabels().as_view()),
    url(r'^switch/controller/(?P<mac_address>.+)/', views.GetSwitchesForCntl().as_view()),
    url(r'^switch/region-pop/(?P<mac_address>.+)/', views.GetSwitchRegionPop().as_view()),
    url(r'^switch/tree/(?P<region>.+)/pops/', views.GetPopsUnderRegionForTree().as_view()),
    url(r'^switch/tree/(?P<region>.+)/(?P<pop>.+)/', views.GetSwitchesUnderPopForTree().as_view()),
    url(r'^switch/tree/regions/', views.GetSwitchRegionsForTree().as_view()),
    url(r'^switch/regions-pops/', views.GetAllSwitchRegionsPops().as_view()),
    url(r'^switch/unattached/', views.GetAllUnattachedSwitches().as_view()),
    url(r'^switch/versions/', views.GetAllSwitchesWithVersions().as_view()),
    url(r'^switch/configuration/ids/', views.SwitchCfgIds().as_view()),
    url(r'^switch/auto/counts/', views.SwitchAutoCounts().as_view()),
    url(r'^switch/delete/(?P<mac_address>.+)/', views.DeleteSwitch().as_view()),
    url(r'^switch/', views.GetSwitches().as_view()),

    # OLT Endpoints
    path('<version>/olts/', include('olts.urls')),

    url(r'^olt/firmware/first/(?P<firmware>.+)/', views.GetFirstAssignedOltFirmware().as_view()),
    url(r'^olt/labels/', views.GetAllOltLabels().as_view()),
    url(r'^olt/protection/switchover/automatic/(?P<mac_address>.+)/', views.ProtectionAutomaticSwitchover().as_view()),
    url(r'^olt/protection/switchover/forced/(?P<mac_address>.+)/', views.ProtectionForcedSwitchover().as_view()),
    url(r'^olt/protection/configuration/(?P<mac_address>.+)/', views.ProtectionCfg().as_view()),
    url(r'^olt/alarm/configuration/identifiers/', views.GetAllOltAlarmsIds().as_view()),
    url(r'^olt/switch/inventory/(?P<mac_address>.+)/', views.GetOltsInSwitchInventory().as_view()),
    url(r'^olt/switch/(?P<mac_address>.+)/', views.GetOltsForSwitch().as_view()),
    url(r'^olt/tree/switch/(?P<switch_id>.+)/', views.GetOltsUnderSwitchForTree().as_view()),
    url(r'^olt/tree/controller/(?P<controller_id>.+)/', views.GetOltsUnderControllerForTree().as_view()),
    url(r'^olt/counts/', views.OltCounts().as_view()),
    url(r'^olt/unattached/', views.GetAllUnattachedOlts().as_view()),
    url(r'^olt/unknown/', views.GetOltsForUnknownSwitch().as_view()),
    url(r'^olt/versions/', views.GetAllOltsWithVersions.as_view()),
    url(r'^olt/state/debug/(?P<mac_address>.+)/', views.OltDebugState().as_view()),
    url(r'^olt/state/distinct/', views.OltDistinctIdentifiers().as_view()),
    url(r'^olt/controller/(?P<mac_address>.+)/', views.GetAllOltsForController().as_view()),
    url(r'^olt/configurations/ids/', views.GetAllOltCfgIds().as_view()),
    url(r'^olt/protection/peers/(?P<olt_id>.+)/', views.GetAllAvailableOltPeers().as_view()),
    url(r'^olt/alarm/', views.GetAllOltAlarms().as_view()),
    url(r'^olt/firmware/', views.UploadOltFirmware().as_view()),
    url(r'^olt/onu/upgrade/status/(?P<id>.+)/', views.OltOnuFirmwareUpgradeStatus().as_view()),
    url(r'^olt/onu/automation/(?P<olt_id>.+)/', views.OnuAutomationStatesForOlt().as_view()),
    url(r'^olt/onu/configs/(?P<olt_id>.+)/', views.GetOnuConfigsUnderOlt().as_view()),
    url(r'^olt/onu/states/(?P<olt_id>.+)/', views.GetOnuStatesUnderOlt().as_view()),
    url(r'^olt/auto/counts/', views.OltAutoCounts().as_view()),
    url(r'^olt/delete/(?P<mac_address>.+)/', views.DeleteOlt().as_view()),
    url(r'^olt/all/', views.GetAllOlts().as_view()),
    url(r'^olt/summary/(?P<mac_address>.+)/', views.GetOltSummary().as_view()),
    url(r'^olt/', views.GetOlts().as_view()),

    # ONU Endpoints
    path('<version>/onus/', include('onus.urls')),

    url(r'^onu/registration/allow/(?P<id>.+)/', views.OnuRegistrationAllow().as_view()),
    url(r'^onu/firmware/first/(?P<firmware>.+)/', views.GetFirstAssignedOnuFirmware().as_view()),
    url(r'^onu/labels/', views.GetAllOnuLabels().as_view()),
    url(r'^onu/upgrade/status/(?P<id>.+)/', views.OnuFirmwareUpgradeStatus().as_view()),
    url(r'^onu/state/olt/(?P<mac_address>.+)/', views.GetAllOnuStatesForOlt().as_view()),
    url(r'^onu/alarm/configuration/identifiers/', views.GetAllOnuAlarmsIds().as_view()),
    url(r'^onu/identifiers/gpon/', views.GetAllGponOnuSerialNumbers().as_view()),
    url(r'^onu/inventory/', views.GetOnuInventory().as_view()),
    url(r'^onu/counts/', views.OnuCounts().as_view()),
    url(r'^onu/online/controller/(?P<mac_address>.+)/', views.GetOnlineOnusForController().as_view()),
    url(r'^onu/unspecified/', views.GetUnspecifiedOnus().as_view()),
    url(r'^onu/versions/', views.GetAllOnusWithVersions().as_view()),
    url(r'^onu/many/stats/', views.GetManyOnuStatistics().as_view()),
    url(r'^onu/distinct/stats/', views.GetManyDistinctOnuStatistics().as_view()),
    url(r'^onu/stat/totals/', views.GetOnuStatisticsTotals().as_view()),
    url(r'^onu/olt/(?P<mac_address>.+)/', views.GetOnusForOlt().as_view()),
    url(r'^onu/under/olt/(?P<mac_address>.+)/', views.GetOnusUnderOlt().as_view()),
    url(r'^onu/unattached/', views.GetAllUnattachedOnus().as_view()),
    url(r'^onu/sla/first/(?P<sla>.+)/', views.GetFirstAssignedOnuSla().as_view()),
    url(r'^onu/sla/(?P<sla>.+)/', views.GetAllSlaOnuUsage.as_view()),
    url(r'^onu/service/(?P<srv>.+)/', views.GetAllSrvOnuUsage.as_view()),
    url(r'^onu/state/distinct/', views.OnuDistinctIdentifiers().as_view()),
    url(r'^onu/tree/olt/(?P<olt_id>.+)/', views.GetOnusUnderOltForTree().as_view()),
    url(r'^onu/configuration/ids/', views.GetAllOnuCfgIds().as_view()),
    url(r'^onu/alarm/', views.GetAllOnuAlarms().as_view()),
    url(r'^onu/auto/counts/', views.OnuAutoCounts().as_view()),
    url(r'^onu/(?P<mac_address>.+)/delete/all/', views.DeleteOnu().as_view()),
    url(r'^onu/summary/(?P<mac_address>.+)/', views.GetOnuSummary().as_view()),
    url(r'^onu/', views.GetOnus().as_view()),

    # Picture and Firmware Endpoints
    path('<version>/files/', include('files.urls')),

    url(r'^image/name/', views.ImageNames().as_view()),
    url(r'^image/logo/', views.UploadLogoImage().as_view()),

    # SLA Endpoints
    path('<version>/slas/', include('slas.urls')),

    url(r'^sla/configuration/identifiers/', views.GetAllSlaIds().as_view()),
    url(r'^sla/(?P<sla>.+)/', views.ReplaceSla().as_view()),

    # Service Config Endpoints
    path('<version>/service-configs/', include('service_configs.urls')),

    url(r'^service/configuration/omci/identifiers/', views.GetAllOmciServiceIds().as_view()),
    url(r'^service/configuration/identifiers/', views.GetAllServiceIds().as_view()),
    url(r'^service/info/', views.OmciInfo().as_view()),
    url(r'^service/(?P<srv>.+)/', views.ReplaceSrv().as_view()),

    # Downstream QoS Endpoints
    path('<version>/downstream-maps/', include('downstream_maps.urls')),

    url(r'^downstream-map/configuration/identifiers/', views.GetAllDownstreamMapIds().as_view()),

    # Database Endpoints
    path('<version>/databases/', include('databases.urls')),

    url(r'^database/backup/', views.DatabaseBackup().as_view()),
    url(r'^database/backup/(?P<filename>.+)/', views.DatabaseBackup().as_view()),
    url(r'^database/restore/', views.DatabaseRestore().as_view()),
    url(r'^database/seed/pon/mode/', views.DatabaseSeedOltCFG().as_view()),
    url(r'^database/seed/', views.DatabaseSeeding().as_view()),

    # CPE Endpoints
    path('<version>/cpes/', include('cpes.urls')),

    url(r'^cpe/onu/expired/(?P<mac_address>.+)/', views.ExpiredCpesForOnu().as_view()),  # Delete All Expired (per onu)
    url(r'^cpe/onu/(?P<mac_address>.+)/', views.CpesForOnu().as_view()),  # Delete All, Get All (per onu)

    # User Endpoints
    path('<version>/users/', include('users.urls')),

    url(r'^user/password/requirements/authenticated/', views.SetPasswordRequirements.as_view()),
    url(r'^user/password/requirements/unauthenticated/', views.GetPasswordRequirements.as_view()),
    url(r'^user/recover/validate/', views.ValidateRecoveryCode.as_view()),
    url(r'^user/authenticate/excessive/', views.ExcessiveLoginAttempts.as_view()),
    url(r'^user/password/reset/', views.ResetPassword.as_view()),
    url(r'^user/recover/email/', views.SendRecoveryEmail.as_view()),
    url(r'^user/session/age/all/', views.GetAllSessionAges.as_view()),
    url(r'^user/session/age/', views.UserSessionAgeSetting.as_view()),
    url(r'^user/authenticate/token/', views.AuthenticateUsersToken.as_view()),
    url(r'^user/logout/auto/', views.AutoLogoutUser.as_view()),
    url(r'^user/locale/timestamp/', views.LocaleTimestampFormat.as_view()),
    url(r'^user/pon/mode', views.PonMode.as_view()),
    url(r'^user/log/(?P<email>.+)/(?P<since_utc_time>.+)/', views.GetSysLogsForUser.as_view()),
    url(r'^user/log/(?P<logId>.+)/', views.GetSysLogReturned.as_view()),
    url(r'^user/roles/', views.UserRoles.as_view()),
    url(r'^user/details/(?P<user_email>.+)/', views.UserDetails.as_view()),
    url(r'^user/details/', views.AdminEditUsers.as_view()),
    url(r'^user/permissions/', views.UserPermissions.as_view()),
    url(r'^user/getAll/', views.GetAllUsers.as_view()),
    url(r'^user/exist/', views.GetUsersExist.as_view()),
    url(r'^user/initialize/', views.CreateInitialUser.as_view()),
    url(r'^user/session/', views.RefreshSession.as_view()),
    url(r'^user/active/', views.GetAllActiveUsers.as_view()),
    url(r'^user/(?P<email>.+)/', views.DeleteUser.as_view()),
    url(r'^user/', views.CreateUsers.as_view()),

    # Misc Endpoints
    url(r'^device/query/(?P<collection>.+)/(?P<attribute>.+)/(?P<operator>.+)/(?P<value>.+)/',
        views.CustomDeviceQuery().as_view()),
    url(r'^device/name/(?P<id>.+)/(?P<device_type>.+)/', views.Names().as_view()),
    url(r'^device/thermal/test/(?P<switch_id>.+)/', views.SwitchThermalTestData.as_view()),
    url(r'^device/tree/filter/', views.SearchTreeDevices.as_view()),
    url(r'^device/upgrade/', views.UpgradeConfigurationsToNewVersion.as_view()),
    url(r'^device/search/(?P<collection>.+)/', views.SearchStates.as_view()),
    url(r'^device/bulkchange/', views.MakeBulkChange.as_view()),
    url(r'^device/pictures/', views.DeviceImageNames().as_view()),

    # PON Manager Information
    path('<version>/ponmgr/', include('ponmgr.urls')),

    # Grafana
    url(r'^grafana/olt/links/', views.GrafanaOltLinks.as_view()),
    url(r'^grafana/onu/links/', views.GrafanaOnuLinks.as_view()),

    # global Tibit_Settings
    url(r'^settings/session/age/', views.GlobalSessionAgeSetting.as_view()),
]

urlpatterns = format_suffix_patterns(urlpatterns)
